unit IWCompMemo;
{PUBDIST}

interface

uses
  {$IFDEF VSNET}
  System.ComponentModel, System.Drawing, IWNetClasses,
  {$ELSE}
  Classes,
    {$IFDEF Linux}
    IWCLXComponent, IWCLXClasses,
    {$ELSE}
    IWVCLComponent, IWVCLClasses,
    {$ENDIF}
  {$IFDEF Linux}QControls,{$ELSE}Controls,{$ENDIF}
  {$ENDIF}
  IWHTMLTag, IWControl, IWColor, IWRenderContext, IWBaseInterfaces;

type
  TIWCustomMemo = class(TIWCustomControl, IIWInputControl)
  private
    FHorizScrollBar: Boolean;
    FVertScrollBar: Boolean;
  protected
    FBGColor: TIWColor;
    FLines: TIWStringList;
    FRequired: Boolean;
    FEndsWithCRLF: Boolean;
    FInvisibleBorder: Boolean;
    //
    procedure OnItemsChange( ASender : TObject );
    procedure SetLines(const AValue: TIWStringList);
    procedure SetValue(const AValue: string); virtual;
    procedure SetBGColor(AValue: TIWColor);
    procedure SetVertScrollBar(AValue: Boolean);

    procedure InitControl; override;
  {$IFDEF CLR}
  strict protected
  {$ELSE}
  protected
  {$ENDIF}
    {$IFDEF VSNET}
    function getText: string; reintroduce;virtual;
    procedure setText(AValue: string); reintroduce;virtual;
    {$ELSE}
    {$IFNDEF CLR}
    function getText: TCaption; override;
    {$ENDIF}
    {$IFNDEF CLR}
    procedure TextChangedNotification; override;
    {$ENDIF}
    {$ENDIF}
    procedure Dispose(ADispose: Boolean); override;
  public
    procedure Clear; virtual;
    {$IFNDEF CLR}
    procedure setText(const AValue: TCaption); override;
    {$ENDIF}

    // make it visible to PaintHandler
    function RenderHTML(AContext: TIWBaseHTMLComponentContext): TIWHTMLTag; override;
    function RenderStyle(AComponentContext: TIWBaseHTMLComponentContext): string; override;
    {$IFDEF VSNET}
    [DesignerSerializationVisibility(DesignerSerializationVisibility.Content)]
    property Text: string read getText write setText;
    [DesignerSerializationVisibility(DesignerSerializationVisibility.Content)]
    {$ELSE}
    {$IFNDEF CLR}
    property Text: TCaption read getText write setText;
    {$ENDIF}
    {$ENDIF}
    property Lines: TIWStringList read FLines write SetLines;
  published
    property BGColor: TIWColor read FBGColor write SetBGColor;
    property Editable;
    property ExtraTagParams;
    {$IFDEF CLR}
    property WebFont;
    {$ELSE}
    property Font;
    {$ENDIF}
    property ScriptEvents;
    property InvisibleBorder: Boolean read FInvisibleBorder write FInvisibleBorder;
    property HorizScrollBar: Boolean read FHorizScrollBar write FHorizScrollBar;
    property VertScrollBar: Boolean read FVertScrollBar write SetVertScrollBar;
    property Required: Boolean read FRequired write FRequired;
    property TabOrder;
  end;

  {$IFDEF VSNET}
  {$R icons\Atozed.Intraweb.TIWMemo.bmp}
  TIWMemo = class;
  [ToolboxItem(true), ToolboxBitmap(typeof(TIWMemo), 'TIWMemo.bmp')]
  {$ENDIF}
  TIWMemo = class(TIWCustomMemo)
  public
  published
    property Enabled;
    property FriendlyName;
    {$IFDEF VSNET}
    [Bindable(true)]
    {$ENDIF}
    property Lines;
  end;

implementation

uses
  SysUtils,
  {$IFDEF Linux}QGraphics,{$ELSE}Graphics,{$ENDIF}
  IWAppForm, IWCompText, IWResourceStrings, IWGlobal, IWUtils,
  SWSystem, IWBaseHTMLControl;

procedure TIWCustomMemo.InitControl;
begin
  inherited;  
  FLines := TIWStringList.Create;
  FLines.OnChange := OnItemsChange;
  FNeedsFormTag := True;
  Height := 121;
  Width := 121;
  FEndsWithCRLF := true;
  FBGColor := fromTColor(clNone);
  Set_RenderSize(True);
  FCanReceiveFocus := True;
  FVertScrollBar := True;
  FInvisibleBorder := False;
end;

{$IFDEF VSNET}
function TIWCustomMemo.getText: string;
begin
  Result := FLines.Text;
end;


procedure TIWCustomMemo.setText(AValue: string);
begin
  FLines.Text := AValue;
end;

{$ELSE}
{$IFNDEF CLR}
function TIWCustomMemo.getText: TCaption;
begin
  Result := FLines.Text;
end;


procedure TIWCustomMemo.setText(const AValue: TCaption);
begin
  FLines.Text := AValue;
end;
{$ENDIF}
{$IFNDEF CLR}
procedure TIWCustomMemo.TextChangedNotification;
begin
  FLines.Text := Text;
end;
{$ENDIF}
{$ENDIF}

procedure TIWCustomMemo.Dispose(ADispose: Boolean);
begin
  FreeAndNil(FLines);
  inherited;
end;

function TIWCustomMemo.RenderStyle(AComponentContext: TIWBaseHTMLComponentContext): string;
begin
  result := inherited RenderStyle(AComponentContext);
  result := result + iif(toTColor(BGColor) <> clNone, 'background-color: ' + ColorToRGBString(BGColor) + '; ');
  Result := Result + IIF(not FVertScrollBar, 'overflow: visible;');
  if FInvisibleBorder then begin
    Result := Result + 'border-style: none;border-color: #000000';
  end;
end;

function TIWCustomMemo.RenderHTML(AContext: TIWBaseHTMLComponentContext): TIWHTMLTag;
var
  S: String;
begin
  Result := TIWHTMLTag.CreateTag('TEXTAREA'); try
    // Netscape can handle fonts here using method in TIWEdit, but IE cannot.
    Result.AddStringParam('NAME', HTMLName);
    Result.Add(iif(not Editable, 'READONLY'));
    if not Enabled then begin
      Result.AddBoolParam('DISABLED', True);
    end;
    if FHorizScrollBar then begin
      Result.AddStringParam('WRAP', 'OFF');
    end;
    S := TextToHTML(Text,false,false);
    if not FEndsWithCRLF and (Length(S) >= Length(sLineBreak)) then
      SetLength(S, Length(S) - Length(sLineBreak));
    Result.Contents.AddText(S);
    UseFrame := False;
  except FreeAndNil(Result); raise; end;

  if Required and BaseComponentInterface(Self).SupportsInput then begin
    TIWComponent40Context(AContext).AddValidation(HTMLName + 'IWCL != null && ' + HTMLName + 'IWCL.value.length==0'
     , Format(RSValidationRequeredField, [FriendlyName]));
  end;
end;

procedure TIWCustomMemo.SetBGColor(AValue: TIWColor);
begin
  if FBGColor <> AValue then begin
    FBGColor := AValue;
    Invalidate;
  end;
end;

procedure TIWCustomMemo.SetLines(const AValue: TIWStringList);
begin
  FLines.Assign(AValue);
  FEndsWithCRLF := true;
  Invalidate;
end;

procedure TIWCustomMemo.OnItemsChange( ASender : TObject );
begin
  DoRefreshControl := True;
  Invalidate;
end;

procedure TIWCustomMemo.SetValue(const AValue: string);
begin
  if RequiresUpdateNotification(Parent) then begin
    UpdateNotifiedInterface(Parent).NotifyUpdate(Self,AValue);
  end;
  FLines.Text := AValue;
  FEndsWithCRLF := FLines.Text = AValue;
  // Will use Text internally to set the real value
  Text := AValue;
  Invalidate;
end;

procedure TIWCustomMemo.Clear;
begin
  Lines.Clear;
end;

procedure TIWCustomMemo.SetVertScrollBar(AValue: Boolean);
begin
  if AValue <> FVertScrollBar then begin
    FVertScrollBar := AValue;
    Invalidate;
  end;
end;

end.
